var winproc = require('winprocess');
const WebSocket = require('ws');

////////////////////////////////////////////////
// change num if multiple bridges on one comp //
////////////////////////////////////////////////
var wsPort = 51210;
////////////////////////////////////////////////

var pid = -1;
if(process.argv.length >= 3) {
	pid = Number.parseInt(process.argv[2], 10);
}
if(pid == -1) {
	pid = winproc.getProcessId("cxbxr-ldr.exe");
}
console.log("PID: " + pid);
var cxbx = new winproc.Process(pid);
cxbx.open();

process.on("exit", function(){
	cxbx.close();
});

if(process.argv.length >= 4) {
	wsPort = Number.parseInt(process.argv[3], 10);
}

//function bufferToUInt32(b) {
//	return (b[3] << 24) | (b[2] << 16) | (b[1] << 8) | b[0];
//}

function bufferToUInt32(b, i) {
	return (b[i + 3] << 24) | (b[i + 2] << 16) | (b[i + 1] << 8) | b[i];
}

function parseBufferLine(buf) {
	return {
		flag: buf[0],
		cat: buf[1],
		sub: buf[2],
		b: buf[3],
		dw1: bufferToUInt32(buf, 4),
		dw2: bufferToUInt32(buf, 8),
		dw3: bufferToUInt32(buf, 0xC)
	};
}

//function uInt32ToBuffer(u) {
//	var b = Buffer.alloc(4);
//	b[0] = u & 0xFF;
//	b[1] = (u >> 8) & 0xFF;
//	b[2] = (u >> 16) & 0xFF;
//	b[3] = (u >> 24) & 0xFF;
//	return b;
//}

function writeInt32IntoBuffer(u, b, i) {
	b[i] = u & 0xFF;
	b[i + 1] = (u >> 8) & 0xFF;
	b[i + 2] = (u >> 16) & 0xFF;
	b[i + 3] = (u >> 24) & 0xFF;
}

var zeroBuffer = Buffer.alloc(1);
zeroBuffer[0] = 0;

var oneBuffer = Buffer.alloc(1);
oneBuffer[0] = 1;

var commBufferAddr = 0x288630;
var commBufferLines = 256;
var recvBufferAddr = commBufferAddr;
var sendBufferAddr = recvBufferAddr + (commBufferLines * 0x10);

var recvBufferIdx = 0;
var recvBufferAckIdx = 0;
var sendBufferIdx = 0;

var sendQueue = [];
var recvQueue = [];

function pollForSends() {
	var end = 0;
	do {
		var nextAddr = sendBufferAddr + (sendBufferIdx * 0x10);
		var nextLine = cxbx.readMemory(nextAddr, 0x10);
		var parsed = parseBufferLine(nextLine);
		
		if(parsed.flag == 1) {
			delete parsed.flag;
			
			var j = JSON.stringify(parsed);
			
			if (parsed.cat == 1) {
				console.log("blocked send of can(s)")
			} else {
				sendQueue.push(j);
			}
			
			cxbx.writeMemory(nextAddr, zeroBuffer);
			
			sendBufferIdx++;
			if(sendBufferIdx >= commBufferLines) {
				sendBufferIdx = 0;
			}
			
			console.log("queued send: " + j);
		}
		else {
			end = 1;
		}
	}while(end == 0);
}

function checkAcks() {
	var end = 0;
	while(recvBufferAckIdx != recvBufferIdx && end == 0) {
		var nextAddr = recvBufferAddr + (recvBufferAckIdx * 0x10);
		var nextLine = cxbx.readMemory(nextAddr, 1);
		
		if(nextLine[0] == 0) {
			recvBufferAckIdx++;
			if(recvBufferAckIdx >= commBufferLines) {
				recvBufferAckIdx = 0;
			}
			console.log("ack");
		}
		else {
			exit = 1;
		}
	}
}

function writeRecvs() {
	while(recvQueue.length != 0 && ((recvBufferIdx + 1) & 0xFF) != recvBufferAckIdx) {
		var next = recvQueue.shift();
		var line = Buffer.alloc(15);
		line[0] = next.cat;
		line[1] = next.sub;
		line[2] = next.b;
		writeInt32IntoBuffer(next.dw1, line, 3);
		writeInt32IntoBuffer(next.dw2, line, 7);
		writeInt32IntoBuffer(next.dw3, line, 11);
		
		var lineOffset = recvBufferAddr + (recvBufferIdx * 0x10);
		cxbx.writeMemory(lineOffset + 1, line);
		cxbx.writeMemory(lineOffset, oneBuffer);
		
		recvBufferIdx = (recvBufferIdx + 1) & 0xFF;
		console.log("written");
	}
}

const wss = new WebSocket.Server({
	port: wsPort
});

wss.on("connection", function(ws){
	console.log("websocket connected");
	ws.on("message", function(data){
		console.log("received: " + data);
		
		var parsed = JSON.parse(data);
		recvQueue.push(parsed);
	});
	ws.on("close", function(){
		console.log("websocket disconnected");
	});
});

function hasWSConnection() {
	var con = 0;
	wss.clients.forEach(function(client){
		if(client.readyState === WebSocket.OPEN) {
			con++;
		}
	});
	return con != 0;
}

function commUpdate() {
	checkAcks();
	writeRecvs();
	pollForSends();
	
	if(sendQueue.length != 0 && hasWSConnection()) {
		while(sendQueue.length != 0) {
			var line = sendQueue.shift();
			wss.clients.forEach(function (client){
				if(client.readyState === WebSocket.OPEN) {
					client.send(line);
				}
			});
			console.log("sent");
		}
	}
}

var commInterval = setInterval(commUpdate, 10); // change to 250 later
